USE [dbDataCenter]
GO
/****** Object:  Trigger [dbo].[AfterInsert]    Script Date: 08/08/2016 08:42:30 . ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

DECLARE @Temp TABLE
(
	[InOutCard] [nchar](10) NOT NULL,
	[InOutDate] [smalldatetime] NOT NULL,
	[InOutTime] [smallint] NOT NULL,
	[InOutType] [tinyint] NOT NULL,
	[DeviceName] [nvarchar](50) NOT NULL
);


INSERT INTO @Temp ([InOutCard],[InOutDate],[InOutTime],[InOutType],[DeviceName])
	SELECT 
	RIGHT('0000000000'+CAST(CardID AS VARCHAR(10)),10),
	CAST(CAST((2000+ [Date]/10000) as NVARCHAR(4))+'-'+CAST(([Date] % 10000)/100 AS NVARCHAR(2))+'-'+CAST(([Date] % 100) AS NVARCHAR(2)) AS SMALLDATETIME),
	CAST([Time]/10000 AS SMALLINT)*60 + CAST(([Time]%10000)/100 AS SMALLINT),
	InOutType,DeviceName FROM tblInOutData;

INSERT INTO dbInOutControlManagement.dbo.tblInOut ([InOutCard],[InOutDate],[InOutTime],[InOutType],[DeviceName]) 
SELECT [InOutCard],[InOutDate],[InOutTime],[InOutType],[DeviceName] FROM @Temp AS TempTable 
WHERE NOT EXISTS(SELECT * FROM dbInOutControlManagement.dbo.tblInOut AS InOut WHERE InOut.InOutCard=TempTable.InOutCard AND InOut.InOutDate=TempTable.InOutDate AND InOut.InOutTime=TempTable.InOutTime)

go
